/*! \file 
**********************************************************************************
*Title:                         Discretix Toolkit Certificate Handling ATP Test source file
*
* Filename:                     CERT_TLK_ATP_data.h
*
* Project, Target, subsystem:   Toolkit, Certificate Handling
* 
* Created:                      18.3.2008
*
* \Author                       Sagitb
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _CERT_TLK_ATP_DATA_H_
#define _CERT_TLK_ATP_DATA_H_

#include "DX_VOS_BaseTypes.h"
#include "CERT_TLK_ATP_Defines.h"
#include "tlk_cert_types.h"
#include "tlk_cert_defs.h"
#ifndef DX_NO_TLK_SCLK_SUPPORT
#include "tlk_sclk_api_types.h"
#else
#include "tlk_cert_sclk_api_stub_types.h"
#endif


/* Definitions */
#define CERTTLK_ATP_WORKSPACE_SIZE TLK_CERT_MIN_WORKSPACE_SIZE_IN_BYTES

/* External Symbols */
#ifndef DX_NO_TLK_SCLK_SUPPORT
extern TLK_SCLK_ServiceClockDescriptor_t TST_gServiceClockDesc;
extern TLK_SCLK_ServiceClockDescriptor_t   TST_gServClkDescNonceValid;

#else
extern TLK_SCLK_ServiceClockDescriptor_t *TST_gServiceClockDesc;
extern TLK_SCLK_ServiceClockDescriptor_t  *TST_gServClkDescNonceValid;
#endif
extern TLK_SCLK_ServiceClockDescriptor_t TST_gServClkDescNonceValid;
extern DxBool_t                          TST_gExtKeyUsageEEFlag;
extern DxByte_t                          TST_gCWorkspace[];
extern DxUint32_t                        TST_gCWorkspaceSizeInBytes;
extern DxByte_t                          TST_gEECertificate[];
extern DxUint32_t                        TST_gEECertificateSize;
extern DxByte_t                          TST_g1Certificate[];
extern DxUint32_t                        TST_g1CertificateSize; 
extern DxByte_t                          TST_g2Certificate[];
extern DxUint32_t                        TST_g2CertificateSize ;
extern DxByte_t                          TST_gTRCertificate[];
extern DxUint32_t                        TST_gTRCertificateSize;
extern TLK_CERT_BufferOffest_t           TST_gSubjectNameEE;
extern TLK_CERT_BufferOffest_t           TST_gIssuerNameEE;
extern DxGeneralizedTime_t               TST_gValidNotBeforeEE;
extern DxGeneralizedTime_t               TST_gValidNotAfterEE;
extern TLK_CERT_BufferOffest_t           TST_gSignatureTR;
extern TLK_CERT_BufferOffest_t           TST_gSubjectKeyIdentifierEE;
extern TLK_CERT_BufferOffest_t           TST_gSubjectPublicKeyInfoEE;
extern TLK_CERT_BufferOffest_t           TST_gSubjectPublicKeyInfoModulus;
extern TLK_CERT_BufferOffest_t           TST_gSubjectPublicKeyInfoExponent;
extern TLK_CERT_BufferOffest_t           TST_gKeyUsageEE;
extern TLK_CERT_BufferOffest_t           TST_gSubjectNameTR ;
extern TLK_CERT_BufferOffest_t           TST_gsubjectKeyIdentifierTR ;
extern TLK_CERT_BufferOffest_t           TST_gSubjectPublicKeyInfoTR ;
extern DxSha1Result_t                    TST_gCertificateId;
extern TLK_CERT_Buffer_t                 TST_gServiceClockPwd;
extern DxByte_t                          TST_gServiceClockPwdBuffer[];
extern DxUint32_t                        TST_gServiceClockPwdLength;
extern TLK_CERT_Buffer_t                 TST_gServClkDescNonceValidPwd;
extern DxByte_t                          TST_gServClkDescNonceValidPwdBuffer[];
extern DxUint32_t                        TST_gServClkDescNonceValidPwdLength;
extern DxSha1Result_t                    TST_gCertIdentityTBC;
extern DxUint32_t                        TST_gResStatus;
extern DxGeneralizedTime_t               TST_gResOnTbcWithNoNonceNextUpdate;
extern DxGeneralizedTime_t               TST_gResOnTbcWithNonceNextUpdate;
extern DxByte_t                          TST_gExtractedCertificte[]; 
extern DxUint32_t                        TST_gExtractedCertificteSize;
extern DxUint8_t                         TST_ga67RSAPrivateKey[];
extern DxUint32_t                        TST_ga67RSAPrivateKeyDataLength;
extern DxByte_t                          TST_gTBCCertificte[];
extern DxUint32_t                        TST_gTBCCertificteSize;
extern DxByte_t                          TST_gResOnTbcWithNonce[];
extern DxUint32_t                        TST_gResOnTbcWithNonceSize;
extern DxByte_t                          TST_gResOnTbcWithNoNonce[];
extern DxUint32_t                        TST_gResOnTbcWithNoNonceSize;
extern DxSha1Result_t                    TST_gCertIdentifier;
extern DxGeneralizedTime_t               TST_gProducedAtOfResOnTbcWithNonce;
extern DxGeneralizedTime_t               TST_gProducedAtOfTST_gResOnTbcWithNoNonce;
extern DxUint32_t                        TST_gCertStatus;

#endif
